IF EXISTS (SELECT  * FROM SYS.TRIGGERS WHERE NAME = 'TRG_RC_DEB_ULT_MOV')
BEGIN
	DROP TRIGGER TRG_RC_DEB_ULT_MOV
END 
GO 

CREATE TRIGGER TRG_RC_DEB_ULT_MOV ON RC_DEB 
FOR INSERT,UPDATE
/*
=======================================================================================
'Job.................:  
'Função..............: 
'Objetivo............: Reprocessamento de Saldo dos Conveniados 
'Tabelas.............: 
'Dt Modificação......: 15/01/2021
'Modificação.........: Reprocessamento de Saldo dos Conveniados que estava aguadando pagamento ST_FECHVD_CONV = 7
'=======================================================================================
Tag #A001 - Alteração do codigo  
Tag #I001 - Inclusão de novo codigo 
*/
AS 

IF UPDATE (STS_DP)
BEGIN 


	INSERT INTO RC_CLI_CONV_RC_CLI_SALDO_PENDENTE (CD_EMP, CD_CLI, CD_CONV, DT_CAD )
		SELECT DISTINCT 
			   RC_CLI_CONV_RC_CLI.CD_EMP, 
		       RC_CLI_CONV_RC_CLI.CD_CLI, 
		       RC_CLI_CONV_RC_CLI.CD_CONV,  
		       GETDATE()  AS DT_CAD 
	      FROM RC_DEB INSERTED 
		       JOIN RC_DEB_RC_CLI_CONV ON INSERTED.CD_EMP	 = RC_DEB_RC_CLI_CONV.CD_EMP
								      AND INSERTED.CD_FILIAL = RC_DEB_RC_CLI_CONV.CD_FILIAL
								      AND INSERTED.CD_RC_DEB = RC_DEB_RC_CLI_CONV.CD_RC_DEB

		       JOIN RC_CLI_CONV ON RC_CLI_CONV.CD_EMP  = RC_DEB_RC_CLI_CONV.CD_EMP
						       AND RC_CLI_CONV.CD_CONV = RC_DEB_RC_CLI_CONV.CD_CONV

		       JOIN RC_VD_CONV_RC_DEB ON RC_VD_CONV_RC_DEB.CD_FILIAL = INSERTED.CD_FILIAL
								     AND RC_VD_CONV_RC_DEB.CD_RC_DEB = INSERTED.CD_RC_DEB

		       JOIN RC_VD_CONV ON RC_VD_CONV.CD_EMP = RC_VD_CONV_RC_DEB.CD_EMP
						      AND RC_VD_CONV.CD_CTR = RC_VD_CONV_RC_DEB.CD_CTR

		       JOIN RC_CLI_CONV_RC_CLI ON RC_CLI_CONV_RC_CLI.CD_EMP  = RC_VD_CONV.CD_EMP   
								      AND RC_CLI_CONV_RC_CLI.CD_CONV = RC_VD_CONV.CD_CONV 
								      AND RC_CLI_CONV_RC_CLI.CD_CLI  = RC_VD_CONV.CD_CLI  
	      WHERE INSERTED.CD_EMP = 1 
	        AND INSERTED.STS_DP = 1
	        --AND ISNULL(RC_CLI_CONV.FLAG_LIBERA_LIMITE_COMPRA,0) = 1 
			and RC_VD_CONV.ST_FECHVD_CONV = 7 
  
END 